<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\RedirectController;
use App\Http\Controllers\Admin\AuthController as AdminAuthController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Api\ContactController;

// Public routes
Route::get('/', function () {
    return redirect()->route('login');
});

// User authentication routes
Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->middleware('guest');

Route::middleware(['auth', 'active'])->group(function () {
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
    Route::get('/redirect/ghl', [RedirectController::class, 'redirectToGhl'])->name('redirect.ghl');
});

// Admin routes
Route::prefix('admin')->name('admin.')->group(function () {
    // Admin authentication
    Route::get('/login', [AdminAuthController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [AdminAuthController::class, 'login'])->middleware('guest');

    // Protected admin routes
    Route::middleware(['auth', 'admin'])->group(function () {
        Route::post('/logout', [AdminAuthController::class, 'logout'])->name('logout');
        Route::get('/dashboard', function () {
            return view('admin.dashboard');
        })->name('dashboard');

        // User management
        Route::resource('users', UserController::class);

        // Settings
        Route::get('/settings', [SettingController::class, 'index'])->name('settings.index');
        Route::post('/settings/ghl-form-url', [SettingController::class, 'updateGhlFormUrl'])->name('settings.update-ghl-url');
    });
});

// API Routes
Route::prefix('api')->middleware([\App\Http\Middleware\HandleCors::class])->group(function () {
    Route::options('/contact/{contactId}', [ContactController::class, 'options']);
    Route::get('/contact/{contactId}', [ContactController::class, 'getContact'])->name('api.contact.get');
});
